package com.estimote.scanning_sdk.packet_provider

import com.estimote.internal_plugins_api.scanning.*
import com.estimote.scanning_sdk.settings.*
import io.reactivex.Observable

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal interface PacketProvider {

    fun provideIBeacon(scanSettings: IBeaconScanSettings) : Observable<out Beacon>
    fun provideEddystoneUid(scanSettings: EddystoneScanSettings) : Observable<out EddystoneUid>
    fun provideEstimoteLocation(scanSettings: EstimoteLocationScanSettings) : Observable<out EstimoteLocation>
    fun provideEstimoteMesh(scanSettings: EstimoteMeshScanSettings): Observable<out EstimoteMesh>
    fun provideConnectivity(scanSettings: ConnectivityScanSettings): Observable<out EstimoteConnectivity>
}