package com.estimote.scanning_sdk.dagger

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.parsers.*
import com.estimote.scanning_sdk.packet_provider.recognizers.*
import com.estimote.scanning_sdk.packet_provider.rssi_smoothers.*
import com.estimote.scanning_sdk.packet_provider.use_cases.*
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class UseCaseModule {

    @Provides
    @EstimoteScanningSdkScope
    fun provideTimer(): Timer = AndroidTimer()

    @Provides
    @EstimoteScanningSdkScope
    fun provideRssiExpirationCacheFactory(timer: Timer) = RssiSmootherExpirationCacheFactory(timer)

    @Provides
    @EstimoteScanningSdkScope
    fun provideIBeaconScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) = IBeaconScanUseCase(estimoteScanner, IBeaconRecognizer(), IBeaconParser(), rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEddystoneUidScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) = EddystoneUidScanUseCase(estimoteScanner, EddystoneUidRecognizer(), EddystoneUidParser(), rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteLocationScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) = EstimoteLocationScanUseCase(estimoteScanner, EstimoteLocationV1Recognizer(), EstimoteLocationV1Parser(), rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteMeshScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) = EstimoteMeshScanUseCase(estimoteScanner, EstimoteMeshRecognizer(), EstimoteMeshParser(), rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteConnectivityScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) = EstimoteConnectivityScanUseCase(estimoteScanner, EstimoteConnectivityRecognizer(), EstimoteConnectivityParser(), rssiSmootherExpirationCacheFactory.create())
}