package com.estimote.scanning_sdk.dagger

import android.bluetooth.le.BluetoothLeScanner
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScannerFactory
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner
import com.estimote.scanning_sdk.packet_provider.scanner.ScannerFactory
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */

@Module
internal class ScannerModule(private val androidVersion: Int,
                             private val manufacturerId: String) {

    @Provides
    @EstimoteScanningSdkScope
    fun provideScannerFactory(bluetoothLeScanner: BluetoothLeScanner): ScannerFactory = EstimoteScannerFactory(bluetoothLeScanner)

    @Provides
    @EstimoteScanningSdkScope
    fun provideScanner(scannerFactory: ScannerFactory): EstimoteScanner = scannerFactory.create(androidVersion, manufacturerId)

}