/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.scanner.PostLollipopEstimoteScanner;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_sdk.settings.EstimoteScanSettings;
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/scanner/PostLollipopEstimoteScanner;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;", "bluetoothLeScanner", "Landroid/bluetooth/le/BluetoothLeScanner;", "scanSettingsTransformer", "Lcom/estimote/scanning_sdk/settings/ScanSettingsVisitor;", "Landroid/bluetooth/le/ScanSettings;", "scanFiltersTransformer", "", "Landroid/bluetooth/le/ScanFilter;", "(Landroid/bluetooth/le/BluetoothLeScanner;Lcom/estimote/scanning_sdk/settings/ScanSettingsVisitor;Lcom/estimote/scanning_sdk/settings/ScanSettingsVisitor;)V", "scan", "Lio/reactivex/Observable;", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "scanSettings", "Lcom/estimote/scanning_sdk/settings/EstimoteScanSettings;", "toEstimoteScanResult", "Landroid/bluetooth/le/ScanResult;", "scanning-sdk_release"})
@TargetApi(value=21)
public final class PostLollipopEstimoteScanner
implements EstimoteScanner {
    private final BluetoothLeScanner bluetoothLeScanner;
    private final ScanSettingsVisitor<ScanSettings> scanSettingsTransformer;
    private final ScanSettingsVisitor<List<ScanFilter>> scanFiltersTransformer;

    @Override
    @TargetApi(value=24)
    @NotNull
    public Observable<EstimoteScanResult> scan(@NotNull EstimoteScanSettings scanSettings) {
        Intrinsics.checkParameterIsNotNull((Object)scanSettings, (String)"scanSettings");
        Observable observable = Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(this, scanSettings){
            final /* synthetic */ PostLollipopEstimoteScanner this$0;
            final /* synthetic */ EstimoteScanSettings $scanSettings;

            public final void subscribe(@NotNull ObservableEmitter<EstimoteScanResult> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                ScanCallback callback2 = new ScanCallback(this, emitter){
                    final /* synthetic */ scan.1 this$0;
                    final /* synthetic */ ObservableEmitter $emitter;

                    public void onScanResult(int callbackType, @NotNull ScanResult result) {
                        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                        this.$emitter.onNext((Object)PostLollipopEstimoteScanner.access$toEstimoteScanResult(this.this$0.this$0, result));
                    }

                    public void onBatchScanResults(@NotNull List<ScanResult> results) {
                        Intrinsics.checkParameterIsNotNull(results, (String)"results");
                        Iterable $receiver$iv = results;
                        for (T element$iv : $receiver$iv) {
                            ScanResult it = (ScanResult)element$iv;
                            this.$emitter.onNext((Object)PostLollipopEstimoteScanner.access$toEstimoteScanResult(this.this$0.this$0, it));
                        }
                    }

                    public void onScanFailed(int errorCode) {
                        this.$emitter.onError((Throwable)new Exception("Bluetooth Low Energy scan failed with error code: " + errorCode));
                    }
                    {
                        this.this$0 = $outer;
                        this.$emitter = $captured_local_variable$1;
                    }
                };
                emitter.setCancellable(new Cancellable(this, callback2){
                    final /* synthetic */ scan.1 this$0;
                    final /* synthetic */ scan.callback.1 $callback;

                    public final void cancel() {
                        PostLollipopEstimoteScanner.access$getBluetoothLeScanner$p(this.this$0.this$0).stopScan((ScanCallback)this.$callback);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = var2_2;
                    }
                });
                PostLollipopEstimoteScanner.access$getBluetoothLeScanner$p(this.this$0).startScan((List)this.$scanSettings.accept(PostLollipopEstimoteScanner.access$getScanFiltersTransformer$p(this.this$0)), (ScanSettings)this.$scanSettings.accept(PostLollipopEstimoteScanner.access$getScanSettingsTransformer$p(this.this$0)), callback2);
            }
            {
                this.this$0 = postLollipopEstimoteScanner;
                this.$scanSettings = estimoteScanSettings;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.create { emit\u2026mer), callback)\n        }");
        return observable;
    }

    private final EstimoteScanResult toEstimoteScanResult(@NotNull ScanResult $receiver) {
        BluetoothDevice bluetoothDevice = $receiver.getDevice();
        Intrinsics.checkExpressionValueIsNotNull((Object)bluetoothDevice, (String)"device");
        int n = $receiver.getRssi();
        long l = $receiver.getTimestampNanos();
        ScanRecord scanRecord = $receiver.getScanRecord();
        Intrinsics.checkExpressionValueIsNotNull((Object)scanRecord, (String)"scanRecord");
        return new EstimoteScanResult(bluetoothDevice, n, l, scanRecord);
    }

    public PostLollipopEstimoteScanner(@NotNull BluetoothLeScanner bluetoothLeScanner, @NotNull ScanSettingsVisitor<ScanSettings> scanSettingsTransformer, @NotNull ScanSettingsVisitor<? extends List<ScanFilter>> scanFiltersTransformer) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothLeScanner, (String)"bluetoothLeScanner");
        Intrinsics.checkParameterIsNotNull(scanSettingsTransformer, (String)"scanSettingsTransformer");
        Intrinsics.checkParameterIsNotNull(scanFiltersTransformer, (String)"scanFiltersTransformer");
        this.bluetoothLeScanner = bluetoothLeScanner;
        this.scanSettingsTransformer = scanSettingsTransformer;
        this.scanFiltersTransformer = scanFiltersTransformer;
    }

    @NotNull
    public static final /* synthetic */ EstimoteScanResult access$toEstimoteScanResult(PostLollipopEstimoteScanner $this, @NotNull ScanResult $receiver) {
        return $this.toEstimoteScanResult($receiver);
    }

    @NotNull
    public static final /* synthetic */ BluetoothLeScanner access$getBluetoothLeScanner$p(PostLollipopEstimoteScanner $this) {
        return $this.bluetoothLeScanner;
    }

    @NotNull
    public static final /* synthetic */ ScanSettingsVisitor access$getScanFiltersTransformer$p(PostLollipopEstimoteScanner $this) {
        return $this.scanFiltersTransformer;
    }

    @NotNull
    public static final /* synthetic */ ScanSettingsVisitor access$getScanSettingsTransformer$p(PostLollipopEstimoteScanner $this) {
        return $this.scanSettingsTransformer;
    }
}

