/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.internal_plugins_api.scanning.Duration;
import com.estimote.internal_plugins_api.scanning.Magnetometer;
import com.estimote.scanning_sdk.common.ByteExtensionsKt;
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_sdk.packet_provider.EstimoteMagnetometer;
import com.estimote.scanning_sdk.packet_provider.EstimoteTelemetryFrameBPacket;
import com.estimote.scanning_sdk.packet_provider.EstimoteUptimeDuration;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\n*\u00020\u0011H\u0002J\f\u0010\u0013\u001a\u00020\n*\u00020\u0011H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0011H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0011H\u0002J\f\u0010\u0018\u001a\u00020\u0010*\u00020\u0011H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/parsers/EstimoteTelemetryBV1Parser;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteTelemetryFrameBPacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "recalculateIfCountedInWeeks", "", "value", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "transformToTimeUnit", "getAmbientLight", "", "Ljava/nio/ByteBuffer;", "getBatteryLevel", "getBatteryVoltage", "getMagnetometer", "Lcom/estimote/internal_plugins_api/scanning/Magnetometer;", "getShortIdentifier", "", "getTemperature", "getUptime", "Lcom/estimote/internal_plugins_api/scanning/Duration;", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteTelemetryBV1Parser
implements EstimoteScanResultParser<EstimoteTelemetryFrameBPacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteTelemetryFrameBPacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.device.address");
        return new EstimoteTelemetryFrameBPacket(new EstimoteMacAddress(string), result.getRssi(), result.getTimestampNanosSinceBoot(), this.getShortIdentifier($receiver), this.getMagnetometer($receiver), this.getAmbientLight($receiver), this.getUptime($receiver), this.getTemperature($receiver), this.getBatteryVoltage($receiver), this.getBatteryLevel($receiver));
    }

    private final String getShortIdentifier(@NotNull ByteBuffer $receiver) {
        byte[] shortIdBytes = new byte[8];
        $receiver.position(1);
        $receiver.get(shortIdBytes, 0, 8);
        return ByteExtensionsKt.toHex(shortIdBytes);
    }

    private final Magnetometer getMagnetometer(@NotNull ByteBuffer $receiver) {
        double x = (double)$receiver.get(10) / 128.0;
        double y = (double)$receiver.get(11) / 128.0;
        double z = (double)$receiver.get(12) / 128.0;
        return new EstimoteMagnetometer(x, y, z);
    }

    private final double getAmbientLight(@NotNull ByteBuffer $receiver) {
        byte ambientByte;
        byte by = ambientByte = $receiver.get(13);
        int n = 240;
        double d = 2.0;
        byte by2 = (byte)(by & n);
        by = ambientByte;
        n = 15;
        d = Math.pow(d, ByteExtensionsKt.toUnsignedInt(by2) >> 4);
        by2 = (byte)(by & n);
        return d * (double)ByteExtensionsKt.toUnsignedInt(by2) * 0.72;
    }

    private final Duration getUptime(@NotNull ByteBuffer $receiver) {
        byte uptimeHigherByte;
        byte uptimeLowerByte = $receiver.get(14);
        byte by = $receiver.get(15);
        byte by2 = (byte)63;
        by2 = uptimeHigherByte = (byte)(by & by2);
        int n = 15;
        int n2 = ByteExtensionsKt.toUnsignedInt(uptimeLowerByte);
        byte by3 = (byte)(by2 & n);
        int durationValue = n2 + (ByteExtensionsKt.toUnsignedInt(by3) << 8);
        TimeUnit unitValue = this.transformToTimeUnit(ByteExtensionsKt.toUnsignedInt(uptimeHigherByte) >> 4);
        int recalculatedValue = this.recalculateIfCountedInWeeks(durationValue, unitValue);
        return new EstimoteUptimeDuration(recalculatedValue, unitValue);
    }

    private final double getTemperature(@NotNull ByteBuffer $receiver) {
        byte by = $receiver.get(15);
        byte by2 = (byte)192;
        byte temperatureLowByte = (byte)(by & by2);
        byte temperatureMidByte = $receiver.get(16);
        byte by3 = $receiver.get(17);
        byte by4 = (byte)3;
        byte temperatureHighByte = (byte)(by3 & by4);
        return (double)((ByteExtensionsKt.toUnsignedInt(temperatureLowByte) >> 6) + (ByteExtensionsKt.toUnsignedInt(temperatureMidByte) << 2) + (ByteExtensionsKt.toUnsignedInt(temperatureHighByte) << 10)) / 16.0;
    }

    private final int getBatteryVoltage(@NotNull ByteBuffer $receiver) {
        byte by = $receiver.get(17);
        byte by2 = (byte)252;
        byte batteryVoltageLowByte = (byte)(by & by2);
        byte batteryVoltageHighByte = $receiver.get(18);
        return (ByteExtensionsKt.toUnsignedInt(batteryVoltageLowByte) >> 2) + (ByteExtensionsKt.toUnsignedInt(batteryVoltageHighByte) << 6);
    }

    private final int getBatteryLevel(@NotNull ByteBuffer $receiver) {
        return ByteExtensionsKt.toUnsignedInt($receiver.get(19));
    }

    private final TimeUnit transformToTimeUnit(int value) {
        TimeUnit timeUnit;
        switch (value) {
            case 0: {
                timeUnit = TimeUnit.SECONDS;
                break;
            }
            case 1: {
                timeUnit = TimeUnit.MINUTES;
                break;
            }
            case 2: {
                timeUnit = TimeUnit.HOURS;
                break;
            }
            case 3: {
                timeUnit = TimeUnit.DAYS;
                break;
            }
            default: {
                timeUnit = TimeUnit.MILLISECONDS;
            }
        }
        return timeUnit;
    }

    private final int recalculateIfCountedInWeeks(int value, TimeUnit timeUnit) {
        return Intrinsics.areEqual((Object)((Object)timeUnit), (Object)((Object)TimeUnit.DAYS)) && value > 31 ? 7 * value : value;
    }
}

