/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.parsers;

import android.annotation.TargetApi;
import com.estimote.scanning_sdk.common.ByteExtensionsKt;
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_sdk.packet_provider.EstimoteNearablePacket;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\u0005*\u00020\u000bH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u000bH\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\u000bH\u0002J\f\u0010\u0012\u001a\u00020\u0005*\u00020\u000bH\u0002J\f\u0010\u0013\u001a\u00020\u0010*\u00020\u000bH\u0002J\f\u0010\u0014\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0015\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\u0016\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0017\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/parsers/EstimoteNearableParser;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_sdk/packet_provider/EstimoteNearablePacket;", "()V", "ESTIMOTE_MANUFACTURER_ID", "", "parse", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "getAdvertisingChannel", "", "Ljava/nio/ByteBuffer;", "getBatteryVoltage", "", "getCurrentMotionStateSeconds", "getDeviceId", "", "getHardwareVersion", "getPreviousMotionStateSeconds", "getSoftwareVersion", "getTemperature", "getTxPower", "getXAcceleration", "getYAcceleration", "getZAcceleration", "isMoving", "", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteNearableParser
implements EstimoteScanResultParser<EstimoteNearablePacket> {
    private final int ESTIMOTE_MANUFACTURER_ID = 349;

    @Override
    @NotNull
    public EstimoteNearablePacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer bytes;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = bytes = ByteBuffer.wrap(result.getScanRecord().getManufacturerSpecificData(this.ESTIMOTE_MANUFACTURER_ID));
        String string = this.getDeviceId($receiver);
        String string2 = this.getHardwareVersion($receiver);
        String string3 = this.getSoftwareVersion($receiver);
        double d = this.getTemperature($receiver);
        double d2 = this.getBatteryVoltage($receiver);
        boolean bl = this.isMoving($receiver);
        double d3 = this.getXAcceleration($receiver);
        double d4 = this.getYAcceleration($receiver);
        double d5 = this.getZAcceleration($receiver);
        int n = this.getCurrentMotionStateSeconds($receiver);
        int n2 = this.getPreviousMotionStateSeconds($receiver);
        byte by = this.getTxPower($receiver);
        byte by2 = this.getAdvertisingChannel($receiver);
        String string4 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"result.device.address");
        return new EstimoteNearablePacket(string, string2, string3, d, d2, bl, d3, d4, d5, n, n2, by, by2, new EstimoteMacAddress(string4), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final String getDeviceId(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[8];
        $receiver.position(1);
        $receiver.get(bytes, 0, 8);
        return ByteExtensionsKt.toHex(bytes);
    }

    private final String getHardwareVersion(@NotNull ByteBuffer $receiver) {
        String string;
        $receiver.position(9);
        switch ($receiver.get()) {
            case 0: {
                string = "Hardware unknown";
                break;
            }
            case 1: {
                string = "D3.2";
                break;
            }
            case 2: {
                string = "D3.3";
                break;
            }
            case 3: {
                string = "D3.4";
                break;
            }
            case 4: {
                string = "SB0";
                break;
            }
            case 5: {
                string = "Sb4b";
                break;
            }
            case 6: {
                string = "SB5b";
                break;
            }
            case 7: {
                string = "S3A6";
                break;
            }
            case 8: {
                string = "S3A6b";
                break;
            }
            case 9: {
                string = "SCA2";
                break;
            }
            case 10: {
                string = "SCA3";
                break;
            }
            case 11: {
                string = "SC1.0";
                break;
            }
            default: {
                string = "RFU";
            }
        }
        return string;
    }

    private final String getSoftwareVersion(@NotNull ByteBuffer $receiver) {
        String string;
        $receiver.position(10);
        switch ($receiver.get()) {
            case 0: {
                string = "Bootloader unknown";
                break;
            }
            case 1: {
                string = "Bootloader 1.0.0";
                break;
            }
            case -128: {
                string = "Main app unknown";
                break;
            }
            case -127: {
                string = "Main app 1.0.0";
                break;
            }
            case -126: {
                string = "Main app 1.0.1";
                break;
            }
            case -125: {
                string = "Main app 1.1.0";
                break;
            }
            case -124: {
                string = "Main app 1.2.0";
                break;
            }
            case -123: {
                string = "Main app 1.3.0";
                break;
            }
            default: {
                string = "RFU";
            }
        }
        return string;
    }

    private final double getTemperature(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[2];
        $receiver.position(11);
        $receiver.get(bytes, 0, 2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(bytes).o\u2026(ByteOrder.LITTLE_ENDIAN)");
        short s = byteBuffer.getShort();
        int n = 4095;
        return (double)((short)(s & n) << 4) / 256.0;
    }

    private final double getBatteryVoltage(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[2];
        $receiver.position(12);
        $receiver.get(bytes, 0, 2);
        int bat = ((bytes[0] & 0xFF) >> 4) + ((bytes[1] & 0x3F) << 4);
        return 3.5999999999999996 * (double)bat / (double)1023;
    }

    private final boolean isMoving(@NotNull ByteBuffer $receiver) {
        $receiver.position(13);
        byte by = $receiver.get();
        int n = 64;
        return (byte)(by & n) > 0;
    }

    private final double getXAcceleration(@NotNull ByteBuffer $receiver) {
        $receiver.position(14);
        return (double)$receiver.get() * 0.015625;
    }

    private final double getYAcceleration(@NotNull ByteBuffer $receiver) {
        $receiver.position(15);
        return (double)$receiver.get() * 0.015625;
    }

    private final double getZAcceleration(@NotNull ByteBuffer $receiver) {
        $receiver.position(16);
        return (double)$receiver.get() * 0.015625;
    }

    private final int getCurrentMotionStateSeconds(@NotNull ByteBuffer $receiver) {
        int n;
        $receiver.position(17);
        byte by = $receiver.get();
        int unit = (by & 0xC0) >> 6;
        int value = by & 0x3F;
        switch (unit) {
            case 1: {
                n = 60 * value;
                break;
            }
            case 2: {
                n = 3600 * value;
                break;
            }
            case 3: {
                if (value < 32) {
                    n = 86400 * value;
                    break;
                }
                n = 604800 * (value - 32);
                break;
            }
            default: {
                n = value;
            }
        }
        return n;
    }

    private final int getPreviousMotionStateSeconds(@NotNull ByteBuffer $receiver) {
        int n;
        $receiver.position(18);
        byte by = $receiver.get();
        int unit = (by & 0xC0) >> 6;
        int value = by & 0x3F;
        switch (unit) {
            case 1: {
                n = 60 * value;
                break;
            }
            case 2: {
                n = 3600 * value;
                break;
            }
            case 3: {
                if (value < 32) {
                    n = 86400 * value;
                    break;
                }
                n = 604800 * (value - 32);
                break;
            }
            default: {
                n = value;
            }
        }
        return n;
    }

    private final byte getTxPower(@NotNull ByteBuffer $receiver) {
        byte by;
        $receiver.position(19);
        byte by2 = $receiver.get();
        int n = 15;
        switch ((byte)(by2 & n)) {
            case 0: {
                by = -30;
                break;
            }
            case 1: {
                by = -20;
                break;
            }
            case 2: {
                by = -16;
                break;
            }
            case 3: {
                by = -12;
                break;
            }
            case 4: {
                by = -8;
                break;
            }
            case 5: {
                by = -4;
                break;
            }
            case 6: {
                by = 0;
                break;
            }
            default: {
                by = 4;
            }
        }
        return by;
    }

    private final byte getAdvertisingChannel(@NotNull ByteBuffer $receiver) {
        byte by;
        $receiver.position(19);
        byte by2 = $receiver.get();
        int n = 48;
        switch ((byte)(by2 & n) >> 4) {
            case 1: {
                by = 37;
                break;
            }
            case 2: {
                by = 38;
                break;
            }
            case 3: {
                by = 39;
                break;
            }
            default: {
                by = -1;
            }
        }
        return by;
    }
}

