/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.dagger;

import android.bluetooth.le.ScanFilter;
import com.estimote.scanning_sdk.dagger.EstimoteScanningSdkScope;
import com.estimote.scanning_sdk.packet_provider.antenna_bias.AntennaBiasCorrection;
import com.estimote.scanning_sdk.packet_provider.antenna_bias.AntennaBiasCorrectionFactory;
import com.estimote.scanning_sdk.packet_provider.scanner.BluetoothLeScannerProvider;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScannerFactory;
import com.estimote.scanning_sdk.packet_provider.scanner.ScannerFactory;
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor;
import dagger.Module;
import dagger.Provides;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J,\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/estimote/scanning_sdk/dagger/ScannerModule;", "", "androidVersion", "", "manufacturerId", "", "deviceModel", "(ILjava/lang/String;Ljava/lang/String;)V", "provideAntennaBiasCorrectionFactory", "Lcom/estimote/scanning_sdk/packet_provider/antenna_bias/AntennaBiasCorrection;", "provideScanner", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanner;", "scannerFactory", "Lcom/estimote/scanning_sdk/packet_provider/scanner/ScannerFactory;", "provideScannerFactory", "bluetoothLeScannerProvider", "Lcom/estimote/scanning_sdk/packet_provider/scanner/BluetoothLeScannerProvider;", "scanSettingsTransformerProvider", "Lcom/estimote/scanning_sdk/packet_provider/scanner/settings_transformers/ScanSettingsTransformerProvider;", "scanFiltersTransformer", "Lcom/estimote/scanning_sdk/settings/ScanSettingsVisitor;", "", "Landroid/bluetooth/le/ScanFilter;", "scanning-sdk_release"})
public final class ScannerModule {
    private final int androidVersion;
    private final String manufacturerId;
    private final String deviceModel;

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final ScannerFactory provideScannerFactory(@NotNull BluetoothLeScannerProvider bluetoothLeScannerProvider, @NotNull ScanSettingsTransformerProvider scanSettingsTransformerProvider, @NotNull ScanSettingsVisitor<? extends List<ScanFilter>> scanFiltersTransformer) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothLeScannerProvider, (String)"bluetoothLeScannerProvider");
        Intrinsics.checkParameterIsNotNull((Object)scanSettingsTransformerProvider, (String)"scanSettingsTransformerProvider");
        Intrinsics.checkParameterIsNotNull(scanFiltersTransformer, (String)"scanFiltersTransformer");
        return new EstimoteScannerFactory(bluetoothLeScannerProvider, scanSettingsTransformerProvider, scanFiltersTransformer);
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final EstimoteScanner provideScanner(@NotNull ScannerFactory scannerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)scannerFactory, (String)"scannerFactory");
        return scannerFactory.create(this.androidVersion);
    }

    @Provides
    @EstimoteScanningSdkScope
    @NotNull
    public final AntennaBiasCorrection provideAntennaBiasCorrectionFactory() {
        return new AntennaBiasCorrectionFactory().getAntennaBiasForDevice(this.manufacturerId, this.deviceModel);
    }

    public ScannerModule(int androidVersion, @NotNull String manufacturerId, @NotNull String deviceModel) {
        Intrinsics.checkParameterIsNotNull((Object)manufacturerId, (String)"manufacturerId");
        Intrinsics.checkParameterIsNotNull((Object)deviceModel, (String)"deviceModel");
        this.androidVersion = androidVersion;
        this.manufacturerId = manufacturerId;
        this.deviceModel = deviceModel;
    }
}

