package com.estimote.scanning_sdk.settings

import java.util.*

internal data class IBeaconScanSettings(
        override val powerMode: EstimoteScanSettings.ScanPowerMode,
        override val callbackMode: EstimoteScanSettings.ScanCallbackMode,
        val uuid: UUID? = null,
        val major: Short? = null,
        val minor: Short? = null) : EstimoteScanSettings {
    override fun <T> accept(scanSettingsVisitor: ScanSettingsVisitor<T>): T = scanSettingsVisitor.visit(this)
}