package com.estimote.scanning_sdk.packet_provider.use_cases

import com.estimote.internal_plugins_api.scanning.EstimoteConnectivity
import com.estimote.internal_plugins_api.scanning.EstimoteTelemetryFrameA
import com.estimote.internal_plugins_api.scanning.EstimoteTelemetryFrameB
import com.estimote.internal_plugins_api.scanning.EstimoteTelemetryFull
import com.estimote.scanning_sdk.packet_provider.telemetry_merger.TelemetryMerger
import io.reactivex.Observable

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class EstimoteTelemetryFullScanUseCase(private val telemetryMerger: TelemetryMerger) {

    fun run(scanFrameA: Observable<out EstimoteTelemetryFrameA>,
            scanFrameB: Observable<out EstimoteTelemetryFrameB>,
            scanConnectivity: Observable<out EstimoteConnectivity>): Observable<EstimoteTelemetryFull> {
        return telemetryMerger.mergedTelemetryStream(scanFrameA, scanFrameB, scanConnectivity)
    }


}