package com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanSettings
import android.os.Build
import com.estimote.scanning_sdk.settings.*
import com.estimote.scanning_sdk.settings.EstimoteScanSettings.ScanCallbackMode
import com.estimote.scanning_sdk.settings.EstimoteScanSettings.ScanPowerMode

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class DefaultScanSettingsTransformer(private val powerModeTransformer: (ScanSettings.Builder, ScanPowerMode) -> ScanSettings.Builder,
                                              private val callbackModeTransformer: (ScanSettings.Builder, ScanCallbackMode) -> ScanSettings.Builder) : ScanSettingsVisitor<ScanSettings> {

    override fun visit(ibeaconScanSettings: IBeaconScanSettings) = createScanSettings(ibeaconScanSettings.powerMode, ibeaconScanSettings.callbackMode)

    override fun visit(eddystoneScanSettings: EddystoneScanSettings) = createScanSettings(eddystoneScanSettings.powerMode, eddystoneScanSettings.callbackMode)

    override fun visit(telemetryScanSettings: EstimoteTelemetryScanSettings) = createScanSettings(telemetryScanSettings.powerMode, telemetryScanSettings.callbackMode)

    override fun visit(estimoteLocationScanSettings: EstimoteLocationScanSettings) = createScanSettings(estimoteLocationScanSettings.powerMode, estimoteLocationScanSettings.callbackMode)

    override fun visit(estimoteMeshScanSettings: EstimoteMeshScanSettings) = createScanSettings(estimoteMeshScanSettings.powerMode, estimoteMeshScanSettings.callbackMode)

    override fun visit(mirrorScanSettings: MirrorScanSettings) = createScanSettings(mirrorScanSettings.powerMode, mirrorScanSettings.callbackMode)

    override fun visit(uwbScanSettings: UwbScanSettings) = createScanSettings(uwbScanSettings.powerMode, uwbScanSettings.callbackMode)

    override fun visit(nearableScanSettings: NearableScanSettings) = createScanSettings(nearableScanSettings.powerMode, nearableScanSettings.callbackMode)

    override fun visit(connectivityScanSettings: ConnectivityScanSettings) = createScanSettings(connectivityScanSettings.powerMode, connectivityScanSettings.callbackMode)

    private fun createScanSettings(powerMode: ScanPowerMode, callbackMode: ScanCallbackMode): ScanSettings =
            ScanSettings.Builder()
                    .apply { powerModeTransformer(this, powerMode) }
                    .apply { callbackModeTransformer(this, callbackMode) }
                    .build()

}