package com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_sdk.settings.ConnectivityScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToConfigurableDeviceFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig) : DefaultScanFiltersTransformer.ScanFilterTransformer<ConnectivityScanSettings> {

    override fun transform(settings: ConnectivityScanSettings): List<ScanFilter> {
        return listOf(
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.estimoteUUID).build(),
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.proximityUUID).build(),
                filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.eddystoneUUID).build())
    }
}