package com.estimote.scanning_sdk.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer
import java.util.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EddystoneUrlRecognizer: EstimoteScanResultRecognizer {

    private val EDDYSTONE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000feaa-0000-1000-8000-00805f9b34fb"))
    private val EDDYSTONE_URL_FRAME_TYPE = 0x10

    override fun recognize(result: EstimoteScanResult): Boolean =
            result.isEddystone() && result.isEddystoneUrlPacket()

    /** @return True if given [ScanRecord] is a Eddystone packet.
     */
    private fun EstimoteScanResult.isEddystone(): Boolean {
        return scanRecord.serviceUuids.contains(EDDYSTONE_SERVICE_UUID)
                && scanRecord.getServiceData(EDDYSTONE_SERVICE_UUID) != null
                && scanRecord.getServiceData(EDDYSTONE_SERVICE_UUID).isNotEmpty()
    }

    private fun EstimoteScanResult.isEddystoneUrlPacket(): Boolean {
        val data = scanRecord.getServiceData(EDDYSTONE_SERVICE_UUID)
        return data[0].toInt() and 0xF0 == EDDYSTONE_URL_FRAME_TYPE
    }

}