package com.estimote.scanning_sdk.packet_provider

import com.estimote.internal_plugins_api.scanning.Acceleration
import com.estimote.internal_plugins_api.scanning.Duration
import com.estimote.internal_plugins_api.scanning.Gpio
import com.estimote.internal_plugins_api.scanning.Magnetometer
import java.util.concurrent.TimeUnit

/**
 * @author arek.biela@estimote.com (Arek Biela).
 */
data class EstimoteAcceleration(
        override val xAxis: Double,
        override val yAxis: Double,
        override val zAxis: Double): Acceleration

data class EstimoteMotionDuration(
        override val value: Int,
        override val timeUnit: TimeUnit) : Duration

data class EstimoteGpio(
        override val pin0: Boolean,
        override val pin1: Boolean,
        override val pin2: Boolean,
        override val pin3: Boolean) : Gpio

data class EstimoteMagnetometer(
        override val xAxis: Double,
        override val yAxis: Double,
        override val zAxis: Double
) : Magnetometer

data class EstimoteUptimeDuration (
        override val value: Int,
        override val timeUnit: TimeUnit
) : Duration