package com.estimote.scanning_sdk.dagger

import android.bluetooth.le.ScanFilter
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.*
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor
import dagger.Module
import dagger.Provides

@Module
internal class ScanSettingsTransformersModule(private val androidApiVersion: Int,
                                              private val manufacturerId: String) {

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteSettingsToFilterTransformer(): ScanSettingsVisitor<@JvmWildcard List<ScanFilter>> =
            DefaultScanFiltersTransformer(
                    ToIBeaconFilterTransformer(HardwareFilterBuilderFactory()),
                    ToEddystoneFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToEstimoteTelemetryFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToEstimoteLocationFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToEstimoteMeshFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToMirrorFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToUwbFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToNearableFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                    ToConfigurableDeviceFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()))

    @Provides
    @EstimoteScanningSdkScope
    fun provideScanSettingsTransformerProvider(): ScanSettingsTransformerProvider = ScanSettingsTransformerProvider(androidApiVersion, manufacturerId)
}