package com.estimote.scanning_sdk.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.EstimoteTelemetryFull
import com.estimote.scanning_sdk.api.use_cases.ScanUseCase
import com.estimote.scanning_sdk.settings.EstimoteScanSettings
import com.estimote.scanning_sdk.settings.EstimoteTelemetryScanSettings

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class SimpleEstimoteTelemetryFullScannerScanLauncher(useCase: ScanUseCase<EstimoteTelemetryScanSettings, EstimoteTelemetryFull>):
    BaseScannerScanLauncher<EstimoteTelemetryScanSettings, EstimoteTelemetryFull, SimpleEstimoteTelemetryFullScannerScanLauncher>(useCase), BluetoothScanner.EstimoteTelemetryFullScannerScanLauncher {
    override val buildSettings: (SimpleEstimoteTelemetryFullScannerScanLauncher) -> EstimoteTelemetryScanSettings = { EstimoteTelemetryScanSettings(it.powerMode, EstimoteScanSettings.ScanCallbackMode.ALL_MATCH) }
}