/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.recognizers;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanRecord;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/recognizers/IBeaconRecognizer;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultRecognizer;", "()V", "APPLE_MANUFACTURER_ID", "", "MANUFACTURER_SPECIFIC_DATA_LENGTH", "recognize", "", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "scanning-sdk_release"})
public final class IBeaconRecognizer
implements EstimoteScanResultRecognizer {
    private final int APPLE_MANUFACTURER_ID = 76;
    private final int MANUFACTURER_SPECIFIC_DATA_LENGTH = 23;

    @Override
    @TargetApi(value=21)
    public boolean recognize(@NotNull EstimoteScanResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ScanRecord scanRecord = result.getScanRecord();
        return scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID) != null && scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID).length == this.MANUFACTURER_SPECIFIC_DATA_LENGTH && scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID)[0] == 2 && scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID)[1] == 21;
    }
}

