/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.recognizers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/recognizers/EstimoteTelemetryAV2Recognizer;", "Lcom/estimote/scanning_sdk/packet_provider/use_cases/EstimoteScanResultRecognizer;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "ESTIMOTE_TELEMETRY_FRAME_TYPE", "", "ESTIMOTE_TELEMETRY_SUBFRAME_A_TYPE", "ESTIMOTE_TELEMETRY_V1_FRAME_SIZE", "ESTIMOTE_TELEMETRY_V1_VERSION", "recognize", "", "result", "Lcom/estimote/scanning_sdk/packet_provider/scanner/EstimoteScanResult;", "scanning-sdk_release"})
@TargetApi(value=21)
public final class EstimoteTelemetryAV2Recognizer
implements EstimoteScanResultRecognizer {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));
    private final int ESTIMOTE_TELEMETRY_FRAME_TYPE = 2;
    private final int ESTIMOTE_TELEMETRY_SUBFRAME_A_TYPE = 0;
    private final int ESTIMOTE_TELEMETRY_V1_VERSION = 2;
    private final int ESTIMOTE_TELEMETRY_V1_FRAME_SIZE = 20;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean recognize(@NotNull EstimoteScanResult result) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID) == null) return false;
        byte[] byArray2 = result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"result.scanRecord.getSer\u2026ta(ESTIMOTE_SERVICE_UUID)");
        byte[] byArray3 = byArray = byArray2;
        if (byArray3.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID).length != this.ESTIMOTE_TELEMETRY_V1_FRAME_SIZE) return false;
        if ((result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID)[9] & 3) != this.ESTIMOTE_TELEMETRY_SUBFRAME_A_TYPE) return false;
        if ((result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID)[0] & 0xF0) >> 4 != this.ESTIMOTE_TELEMETRY_V1_VERSION) return false;
        if ((result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID)[0] & 0xF) != this.ESTIMOTE_TELEMETRY_FRAME_TYPE) return false;
        return true;
    }
}

