/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_sdk.packet_provider.antenna_bias;

import com.estimote.scanning_sdk.packet_provider.antenna_bias.AntennaBiasCorrection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/estimote/scanning_sdk/packet_provider/antenna_bias/AntennaBiasCorrectionFactory;", "", "()V", "biasForGoogleDevices", "", "deviceModel", "", "biasForHuaweiDevices", "biasForMotorolaDevices", "biasForOnePlusDevices", "biasForSamsungDevices", "biasForSonyDevices", "getAntennaBiasForDevice", "Lcom/estimote/scanning_sdk/packet_provider/antenna_bias/AntennaBiasCorrection;", "manufacturer", "getAntennaBiasForManufacturer", "scanning-sdk_release"})
public final class AntennaBiasCorrectionFactory {
    @NotNull
    public final AntennaBiasCorrection getAntennaBiasForDevice(@NotNull String manufacturer, @NotNull String deviceModel) {
        Intrinsics.checkParameterIsNotNull((Object)manufacturer, (String)"manufacturer");
        Intrinsics.checkParameterIsNotNull((Object)deviceModel, (String)"deviceModel");
        return new AntennaBiasCorrection(this.getAntennaBiasForManufacturer(manufacturer, deviceModel));
    }

    private final int getAntennaBiasForManufacturer(String manufacturer, String deviceModel) {
        int n;
        String string;
        String string2 = string = manufacturer;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "huawei": {
                n = this.biasForHuaweiDevices(deviceModel);
                break;
            }
            case "motorola": {
                n = this.biasForMotorolaDevices(deviceModel);
                break;
            }
            case "oneplus": {
                n = this.biasForOnePlusDevices(deviceModel);
                break;
            }
            case "google": {
                n = this.biasForGoogleDevices(deviceModel);
                break;
            }
            case "samsung": {
                n = this.biasForSamsungDevices(deviceModel);
                break;
            }
            case "sony": {
                n = this.biasForSonyDevices(deviceModel);
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private final int biasForMotorolaDevices(String deviceModel) {
        int n;
        String string = deviceModel;
        switch (string.hashCode()) {
            case -783193035: {
                if (string.equals("Nexus 6")) {
                    n = -6;
                    break;
                }
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private final int biasForSonyDevices(String deviceModel) {
        int n;
        String string = deviceModel;
        switch (string.hashCode()) {
            case 66365407: {
                if (string.equals("F8331")) {
                    n = 6;
                    break;
                }
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int biasForOnePlusDevices(String deviceModel) {
        String string = deviceModel;
        switch (string.hashCode()) {
            case 79430: {
                if (!string.equals("One")) return 0;
                return 2;
            }
            case 61506498: {
                if (!string.equals("A0001")) return 0;
                return 2;
            }
        }
        return 0;
    }

    private final int biasForHuaweiDevices(String deviceModel) {
        int n;
        String string = deviceModel;
        switch (string.hashCode()) {
            case 1490819771: {
                if (string.equals("Nexus 6P")) {
                    n = 0;
                    break;
                }
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int biasForSamsungDevices(String deviceModel) {
        String string = deviceModel;
        switch (string.hashCode()) {
            case -401691194: {
                if (!string.equals("SM-G950F")) return 0;
                return -2;
            }
            case -401694077: {
                if (!string.equals("SM-G920F")) return 0;
                return -2;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int biasForGoogleDevices(String deviceModel) {
        String string = deviceModel;
        switch (string.hashCode()) {
            case -78463250: {
                if (!string.equals("Pixel XL")) return 0;
                return 2;
            }
            case 77128294: {
                if (!string.equals("Pixel")) return 0;
                return 5;
            }
        }
        return 0;
    }
}

