package com.estimote.scanning_sdk.settings

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal interface ScanSettingsVisitor<out T> {
    fun visit(estimoteScanResult: IBeaconScanSettings): T
    fun visit(estimoteScanResult: EddystoneScanSettings): T
    fun visit(telemetryScanSettings: EstimoteTelemetryScanSettings): T
    fun visit(estimoteLocationScanSettings: EstimoteLocationScanSettings): T
    fun visit(estimoteMeshScanSettings: EstimoteMeshScanSettings): T
    fun visit(mirrorScanSettings: MirrorScanSettings): T
    fun visit(uwbScanSettings: UwbScanSettings): T
    fun visit(nearableScanSettings: NearableScanSettings): T
    fun visit(connectivityScanSettings: ConnectivityScanSettings): T

}