package com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers

import android.bluetooth.le.ScanSettings
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor
import javax.inject.Named

internal class ScanSettingsTransformerProvider(
        private val manufacturerId: String,
        @Named("DefaultSettingsTransformer") private val defaultTransformer: ScanSettingsVisitor<ScanSettings>,
        @Named("SamsungSettingsTransformer") private val samsungTransformer: ScanSettingsVisitor<ScanSettings>) {

    fun getTransformer(): ScanSettingsVisitor<ScanSettings> =
            if(manufacturerId.isSamsungDevice()) samsungTransformer else defaultTransformer

    private fun String.isSamsungDevice() = this.equals("samsung", ignoreCase = true)
}