package com.estimote.scanning_sdk.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultRecognizer
import java.util.*

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteNearableRecognizer: EstimoteScanResultRecognizer {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))
    private val ESTIMOTE_NEARABLES_PROTOCOL_VERSION = 1
    private val ESTIMOTE_NEARABLES_FRAME_SIZE = 20

    override fun recognize(result: EstimoteScanResult): Boolean {
        return result.scanRecord.getManufacturerSpecificData(0x015D) != null
                && result.scanRecord.getManufacturerSpecificData(0x015D).isNotEmpty()
                && result.scanRecord.getManufacturerSpecificData(0x015D).size == ESTIMOTE_NEARABLES_FRAME_SIZE
                && result.scanRecord.getManufacturerSpecificData(0x015D)[0].toInt() and 0xFF == ESTIMOTE_NEARABLES_PROTOCOL_VERSION
    }
}