package com.estimote.scanning_sdk.packet_provider.parsers

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_sdk.packet_provider.EddystoneUidPacket
import com.estimote.scanning_sdk.packet_provider.EstimoteMacAddress
import com.estimote.scanning_sdk.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_sdk.packet_provider.use_cases.EstimoteScanResultParser

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EddystoneUidParser: EstimoteScanResultParser<EddystoneUidPacket> {

    override fun parse(result: EstimoteScanResult): EddystoneUidPacket {
        return EddystoneUidPacket("", "", EstimoteMacAddress(""), result.rssi, result.timestampNanosSinceBoot)
    }
}