package com.estimote.scanning_sdk.dagger

import android.bluetooth.BluetoothAdapter
import android.bluetooth.le.ScanFilter
import android.bluetooth.le.ScanSettings
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator
import com.estimote.scanning_sdk.api.EstimoteBluetoothBackgroundTriggerConfigurator
import com.estimote.scanning_sdk.packet_provider.scanner.filter_transformers.*
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.DefaultScanSettingsTransformer
import com.estimote.scanning_sdk.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor
import dagger.Module
import dagger.Provides
import javax.inject.Named

@Module
internal class BluetoothTriggerModule {

    @Provides
    @EstimoteScanningSdkScope
    fun providesBluetoothTriggerConfigurator(
            adapter: BluetoothAdapter?,
            scanSettingsTransformerProvider: ScanSettingsTransformerProvider): BluetoothBackgroundTriggerConfigurator =
            EstimoteBluetoothBackgroundTriggerConfigurator(
                    adapter,
                    scanSettingsTransformerProvider.getTransformer(),
                    DefaultScanFiltersTransformer(
                            ToIBeaconFilterTransformer(HardwareFilterBuilderFactory()),
                            ToEddystoneFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteTelemetryFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteLocationFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToEstimoteMeshFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToMirrorFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToUwbFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToNearableFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig()),
                            ToConfigurableDeviceFilterTransformer(HardwareFilterBuilderFactory(), ServicesUuidConfig())))
}