package com.estimote.scanning_sdk.api.use_cases

import android.annotation.TargetApi
import android.app.PendingIntent
import android.bluetooth.BluetoothAdapter
import android.bluetooth.le.ScanFilter
import android.bluetooth.le.ScanSettings
import android.os.Build
import com.estimote.internal_plugins_api.scanning.ScanHandler
import com.estimote.scanning_sdk.settings.EstimoteScanSettings
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor


internal class TriggerUseCase<in SETTINGS_TYPE : EstimoteScanSettings>(
        private val bluetoothAdapter: BluetoothAdapter?,
        private val scanSettingsTransformer: ScanSettingsVisitor<ScanSettings>,
        private val scanFiltersTransformer: ScanSettingsVisitor<List<ScanFilter>>) {

    @TargetApi(Build.VERSION_CODES.O)
    fun run(pendingIntent: PendingIntent?, settings: SETTINGS_TYPE): ScanHandler {
        bluetoothAdapter?.bluetoothLeScanner?.startScan(settings.accept(scanFiltersTransformer), settings.accept(scanSettingsTransformer), pendingIntent)
        return object : ScanHandler {
            override fun stop() {
                bluetoothAdapter?.bluetoothLeScanner?.stopScan(pendingIntent)
                pendingIntent?.cancel()
            }
        }

    }
}