package com.estimote.scanning_sdk.api

import android.bluetooth.BluetoothAdapter
import android.bluetooth.le.ScanFilter
import android.bluetooth.le.ScanSettings
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator
import com.estimote.internal_plugins_api.scanning.BluetoothBackgroundTriggerConfigurator.EstimoteLocationTriggerScanLauncher
import com.estimote.scanning_sdk.api.scan_launchers.SimpleEstimoteConnectivityTriggerScanLauncher
import com.estimote.scanning_sdk.api.scan_launchers.SimpleEstimoteLocationTriggerScanLauncher
import com.estimote.scanning_sdk.api.use_cases.TriggerUseCase
import com.estimote.scanning_sdk.settings.ScanSettingsVisitor


internal class EstimoteBluetoothBackgroundTriggerConfigurator(
        private val adapter: BluetoothAdapter?,
        private val scanSettingsTransformer: ScanSettingsVisitor<ScanSettings>,
        private val scanFiltersTransformer: ScanSettingsVisitor<List<ScanFilter>>): BluetoothBackgroundTriggerConfigurator {

    override fun onEstimoteLocationDetected(): EstimoteLocationTriggerScanLauncher {
        return SimpleEstimoteLocationTriggerScanLauncher(TriggerUseCase(adapter, scanSettingsTransformer, scanFiltersTransformer))
    }

    override fun onEstimoteConnectivityDetected(): BluetoothBackgroundTriggerConfigurator.EstimoteConnectivityTriggerScanLauncher {
        return SimpleEstimoteConnectivityTriggerScanLauncher(TriggerUseCase(adapter, scanSettingsTransformer, scanFiltersTransformer))
    }
}