/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.scanner;

import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanFilter;
import com.estimote.scanning_plugin.packet_provider.scanner.AlwaysErrorEstimoteScaner;
import com.estimote.scanning_plugin.packet_provider.scanner.BluetoothLeScannerProvider;
import com.estimote.scanning_plugin.packet_provider.scanner.PostLollipopEstimoteScanner;
import com.estimote.scanning_plugin.packet_provider.scanner.ScannerFactory;
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanner;
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor;
import java.util.List;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0001\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScannerFactory;", "Lcom/estimote/scanning_plugin/packet_provider/scanner/ScannerFactory;", "bluetoothLeScannerProvider", "Lcom/estimote/scanning_plugin/packet_provider/scanner/BluetoothLeScannerProvider;", "scanSettingsTransformerProvider", "Lcom/estimote/scanning_plugin/packet_provider/scanner/settings_transformers/ScanSettingsTransformerProvider;", "scanFiltersTransformer", "Lcom/estimote/scanning_plugin/settings/ScanSettingsVisitor;", "", "Landroid/bluetooth/le/ScanFilter;", "(Lcom/estimote/scanning_plugin/packet_provider/scanner/BluetoothLeScannerProvider;Lcom/estimote/scanning_plugin/packet_provider/scanner/settings_transformers/ScanSettingsTransformerProvider;Lcom/estimote/scanning_plugin/settings/ScanSettingsVisitor;)V", "create", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanner;", "androidVersion", "", "createPostLollipopScanner", "isSamsungDevice", "", "", "scanning-plugin_release"})
public final class EstimoteScannerFactory
implements ScannerFactory {
    private final BluetoothLeScannerProvider bluetoothLeScannerProvider;
    private final ScanSettingsTransformerProvider scanSettingsTransformerProvider;
    private final ScanSettingsVisitor<List<ScanFilter>> scanFiltersTransformer;

    @Override
    @NotNull
    public EstimoteScanner create(int androidVersion) {
        return androidVersion < 21 ? (EstimoteScanner)new AlwaysErrorEstimoteScaner("Android < 5.0 is not supported") : this.createPostLollipopScanner();
    }

    private final EstimoteScanner createPostLollipopScanner() {
        EstimoteScanner estimoteScanner;
        BluetoothLeScanner bluetoothLeScanner = this.bluetoothLeScannerProvider.createLeScanner();
        if (bluetoothLeScanner != null) {
            BluetoothLeScanner bluetoothLeScanner2;
            BluetoothLeScanner scanner = bluetoothLeScanner2 = bluetoothLeScanner;
            estimoteScanner = new PostLollipopEstimoteScanner(scanner, this.scanSettingsTransformerProvider.getTransformer(), this.scanFiltersTransformer);
        } else {
            estimoteScanner = new AlwaysErrorEstimoteScaner("Unable to create bluetooth LE scanner instance");
        }
        return estimoteScanner;
    }

    private final boolean isSamsungDevice(@NotNull String $receiver) {
        return StringsKt.equals((String)$receiver, (String)"samsung", (boolean)true);
    }

    public EstimoteScannerFactory(@NotNull BluetoothLeScannerProvider bluetoothLeScannerProvider, @NotNull ScanSettingsTransformerProvider scanSettingsTransformerProvider, @Named(value="ScanFilterTransformer") @NotNull ScanSettingsVisitor<? extends List<ScanFilter>> scanFiltersTransformer) {
        Intrinsics.checkParameterIsNotNull((Object)bluetoothLeScannerProvider, (String)"bluetoothLeScannerProvider");
        Intrinsics.checkParameterIsNotNull((Object)scanSettingsTransformerProvider, (String)"scanSettingsTransformerProvider");
        Intrinsics.checkParameterIsNotNull(scanFiltersTransformer, (String)"scanFiltersTransformer");
        this.bluetoothLeScannerProvider = bluetoothLeScannerProvider;
        this.scanSettingsTransformerProvider = scanSettingsTransformerProvider;
        this.scanFiltersTransformer = scanFiltersTransformer;
    }
}

