package com.estimote.scanning_plugin.packet_provider.scanner

import android.bluetooth.le.ScanFilter
import android.os.Build.VERSION_CODES.*
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanner
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor
import javax.inject.Named

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class EstimoteScannerFactory(
        private val bluetoothLeScannerProvider: BluetoothLeScannerProvider,
        private val scanSettingsTransformerProvider: ScanSettingsTransformerProvider,
        @Named("ScanFilterTransformer") private val scanFiltersTransformer: ScanSettingsVisitor<List<ScanFilter>>) : ScannerFactory {

    override fun create(androidVersion: Int): EstimoteScanner =
            if (androidVersion < LOLLIPOP) {
                AlwaysErrorEstimoteScaner("Android < 5.0 is not supported")
            } else {
                createPostLollipopScanner()
            }

    private fun createPostLollipopScanner() =
            bluetoothLeScannerProvider.createLeScanner()?.let { scanner ->
                PostLollipopEstimoteScanner(
                        scanner,
                        scanSettingsTransformerProvider.getTransformer(),
                        scanFiltersTransformer)
            } ?: AlwaysErrorEstimoteScaner("Unable to create bluetooth LE scanner instance")

    private fun String.isSamsungDevice() = this.equals("samsung", ignoreCase = true)

}