package com.estimote.scanning_plugin.dagger

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.antenna_bias.AntennaBiasCorrection
import com.estimote.scanning_plugin.packet_provider.parsers.*
import com.estimote.scanning_plugin.packet_provider.recognizers.*
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.AndroidTimer
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmootherExpirationCacheFactory
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.Timer
import com.estimote.scanning_plugin.packet_provider.telemetry_merger.RxTelemetryMerger
import com.estimote.scanning_plugin.packet_provider.telemetry_merger.TelemetryMerger
import com.estimote.scanning_plugin.packet_provider.use_cases.*
import dagger.Module
import dagger.Provides

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@Module
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class UseCaseModule {

    @Provides
    @EstimoteScanningSdkScope
    fun provideTimer(): Timer =
            AndroidTimer()

    @Provides
    @EstimoteScanningSdkScope
    fun provideRssiExpirationCacheFactory(timer: Timer) =
            RssiSmootherExpirationCacheFactory(timer)

    @Provides
    @EstimoteScanningSdkScope
    fun provideTelemetryMerger(): TelemetryMerger =
            RxTelemetryMerger()

    @Provides
    @EstimoteScanningSdkScope
    fun provideIBeaconScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory, antennaBiasCorrection: AntennaBiasCorrection) =
            IBeaconScanUseCase(estimoteScanner,
                    IBeaconRecognizer(),
                    IBeaconParser(),
                    rssiSmootherExpirationCacheFactory.create(),
                    antennaBiasCorrection)

    @Provides
    @EstimoteScanningSdkScope
    fun provideEddystoneUidScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EddystoneUidScanUseCase(estimoteScanner,
                    EddystoneUidRecognizer(),
                    EddystoneUidParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteLocationScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory, antennaBiasCorrection: AntennaBiasCorrection) =
            EstimoteLocationScanUseCase(estimoteScanner,
                    EstimoteLocationV1Recognizer(),
                    EstimoteLocationV1Parser(),
                    rssiSmootherExpirationCacheFactory.create(),
                    antennaBiasCorrection)

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteMeshScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteMeshScanUseCase(estimoteScanner,
                    EstimoteMeshRecognizer(),
                    EstimoteMeshParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteConnectivityScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteConnectivityScanUseCase(estimoteScanner,
                    EstimoteConnectivityRecognizer(),
                    EstimoteConnectivityParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteRescueScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteRescueScanUseCase(estimoteScanner,
                    EstimoteRescueRecognizer(),
                    EstimoteRescueParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteNearableScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteNearableScanUseCase(estimoteScanner,
                    EstimoteNearableRecognizer(),
                    EstimoteNearableParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteUwbScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteUwbScanUseCase(estimoteScanner,
                    EstimoteUwbRecognizer(),
                    EstimoteUwbParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteMirrorScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory, antennaBiasCorrection: AntennaBiasCorrection) =
            EstimoteMirrorScanUseCase(estimoteScanner,
                    EstimoteMirrorRecognizer(),
                    EstimoteMirrorParser(),
                    rssiSmootherExpirationCacheFactory.create(),
                    antennaBiasCorrection)

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryAV0ScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteTelemetryAV0ScanUseCase(estimoteScanner,
                    EstimoteTelemetryAV0Recognizer(),
                    EstimoteTelemetryAV0Parser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryAV1ScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteTelemetryAV1ScanUseCase(estimoteScanner,
                    EstimoteTelemetryAV1Recognizer(),
                    EstimoteTelemetryAV1Parser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryAV2ScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteTelemetryAV2ScanUseCase(estimoteScanner,
                    EstimoteTelemetryAV2Recognizer(),
                    EstimoteTelemetryAV2Parser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryBV0ScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteTelemetryBV0ScanUseCase(estimoteScanner,
                    EstimoteTelemetryBV0Recognizer(),
                    EstimoteTelemetryBV0Parser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryBV1ScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteTelemetryBV1ScanUseCase(estimoteScanner,
                    EstimoteTelemetryBV1Recognizer(),
                    EstimoteTelemetryBV1Parser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryBV2ScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteTelemetryBV2ScanUseCase(estimoteScanner,
                    EstimoteTelemetryBV2Recognizer(),
                    EstimoteTelemetryBV1Parser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteTelemetryFullUseCase(telemetryMerger: TelemetryMerger) =
            EstimoteTelemetryFullScanUseCase(telemetryMerger)

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteSecureScanUseCase(estimoteScanner: EstimoteScanner, rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteSecureScanUseCase(estimoteScanner,
                    EstimoteSecureRecognizer(),
                    EstimoteSecureParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteConnectivityIBeaconScanUseCase(estimoteScanner: EstimoteScanner,
                                                      rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteConnectivityIBeaconScanUseCase(
                    estimoteScanner,
                    EstimoteConnectivityIBeaconRecognizer(),
                    EstimoteConnectivityIBeaconParser(),
                    rssiSmootherExpirationCacheFactory.create())

    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteRemoteLocationScanUseCase(estimoteScanner: EstimoteScanner,
                                                 rssiSmootherExpirationCacheFactory: RssiSmootherExpirationCacheFactory) =
            EstimoteRemoteLocationScanUseCase(
                    estimoteScanner,
                    EstimoteRemoteLocationRecognizer(),
                    EstimoteRemoteLocationParser(),
                    rssiSmootherExpirationCacheFactory.create())
}