/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.recognizers;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanRecord;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\f\u0010\t\u001a\u00020\u0006*\u00020\nH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/recognizers/EstimoteConnectivityIBeaconRecognizer;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultRecognizer;", "()V", "APPLE_MANUFACTURER_ID", "", "recognize", "", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "isConnectivity", "Landroid/bluetooth/le/ScanRecord;", "scanning-plugin_release"})
public final class EstimoteConnectivityIBeaconRecognizer
implements EstimoteScanResultRecognizer {
    private final int APPLE_MANUFACTURER_ID = 76;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @TargetApi(value=21)
    public boolean recognize(@NotNull EstimoteScanResult result) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ScanRecord scanRecord = result.getScanRecord();
        if (scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID) == null) return false;
        byte[] byArray2 = scanRecord.getManufacturerSpecificData(this.APPLE_MANUFACTURER_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"scanRecord.getManufactur\u2026ta(APPLE_MANUFACTURER_ID)");
        byte[] byArray3 = byArray = byArray2;
        if (byArray3.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        String string = scanRecord.getDeviceName();
        String string2 = string;
        if (!StringsKt.equals((String)string2, (String)"EST", (boolean)true)) {
            if (!StringsKt.equals((String)string2, (String)"estimote", (boolean)true)) return false;
        }
        boolean bl3 = true;
        if (!bl3) return false;
        if (!this.isConnectivity(scanRecord)) return false;
        return true;
    }

    @TargetApi(value=21)
    private final boolean isConnectivity(@NotNull ScanRecord $receiver) {
        return ($receiver.getAdvertiseFlags() & 2) == 2;
    }
}

