package com.estimote.scanning_plugin.packet_provider

import com.estimote.internal_plugins_api.scanning.*
import java.util.*

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
data class BeaconPacket(
        override val proximityUUID: UUID,
        override val major: Int,
        override val minor: Int,
        override val macAddress: MacAddress,
        override val measuredPower: Int,
        override val rssi: Int,
        override val timestamp: Long) : Beacon

data class EstimoteLocationPacket(
        override val deviceId: String,
        override val channel: Int,
        override val protocolVersion: Int,
        override val measuredPower: Int,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteLocation


data class EddystoneUidPacket(
        override val namespace: String,
        override val instance: String,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EddystoneUid

data class EddystoneUrlPacket(
        override val url: String,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EddystoneUrl

data class EstimoteConnectivityPacket(
        override val deviceId: String,
        override val deviceType: DeviceType,
        override val bootloaderVersion: String,
        override val appVersion: String,
        override val shakeToConnect: Boolean,
        override val isButtonPressed: Boolean,
        override val nearToConnect: Boolean,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteConnectivity

data class EstimoteRescuePacket(
        override val ownId: String,
        override val neighbourDeviceId: String,
        override val neighbourUpToDateStatus: Boolean,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long
) : EstimoteRescue

data class EstimoteMeshPacket(
        override val deviceId: String,
        override val meshReportHash: String,
        override val meshId: Int,
        override val settingsVersion: Int,
        override val appVersion: String,
        override val bootloaderVersion: String,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteMesh

data class EstimoteNearablePacket(
        override val deviceId: String,
        override val hardwareVersion: String,
        override val softwareVersion: String,
        override val temperature: Double,
        override val batteryVoltage: Double,
        override val isMoving: Boolean,
        override val xAcceleration: Double,
        override val yAcceleration: Double,
        override val zAcceleration: Double,
        override val currentMotionStateSeconds: Int,
        override val previousMotionStateSeconds: Int,
        override val txPower: Byte,
        override val advertisingChannel: Byte,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteNearable

data class EstimoteMacAddress(override val address: String) : MacAddress

data class EstimoteUwbPacket(
        override val deviceId: String,
        override val distanceEstimates: Map<String, Float>,
        override val rangingInProgress: Boolean,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteUwb

data class EstimoteTelemetryFrameAPacket(
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long,
        override val shortId: String,
        override val acceleration: Acceleration,
        override val motionState: Boolean,
        override val currentMotionDuration: Duration,
        override val previousMotionDuration: Duration,
        override val gpio: Gpio,
        override val pressure: Double) : EstimoteTelemetryFrameA

data class EstimoteTelemetryFrameBPacket(
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long,
        override val shortId: String,
        override val magnetometer: Magnetometer,
        override val ambientLightInLux: Double,
        override val uptime: Duration,
        override val temperatureInCelsiusDegrees: Double,
        override val batteryVoltageInMilliVolts: Int,
        override val batteryLevelPercentage: Int) : EstimoteTelemetryFrameB

data class EstimoteTelemetryFullPacket(
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long,
        override val identifier: String,
        override val magnetometer: Magnetometer,
        override val ambientLightInLux: Double,
        override val uptime: Duration,
        override val temperatureInCelsiusDegrees: Double,
        override val batteryVoltageInMilliVolts: Int,
        override val batteryLevelPercentage: Int,
        override val acceleration: Acceleration,
        override val motionState: Boolean,
        override val currentMotionDuration: Duration,
        override val previousMotionDuration: Duration,
        override val gpio: Gpio,
        override val pressure: Double) : EstimoteTelemetryFull


data class EstimoteMirrorPacket(
        override val deviceId: String,
        override val macAddress: MacAddress,
        override val protocolVersion: Int,
        override val measuredPower: Int,
        override val rssi: Int,
        override val accessControl: Boolean,
        override val timestamp: Long) : EstimoteMirror

data class EstimoteSecurePacket(
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long,
        override val payload: ByteArray) : EstimoteSecure

data class EstimoteLteBeaconPacket(
        override val deviceId: String,
        override val deviceType: DeviceType,
        override val bootloaderVersion: String,
        override val appVersion: String,
        override val shakeToConnect: Boolean,
        override val nearToConnect: Boolean,
        override val isButtonPressed: Boolean,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long) : EstimoteLteBeacon

data class EstimoteRemoteLocationPacket(
        override val deviceId: Short,
        override val heardPackets: List<EstimoteRemoteLocation.HeardPacket>,
        override val macAddress: MacAddress,
        override val rssi: Int,
        override val timestamp: Long): EstimoteRemoteLocation {
}

