package com.estimote.scanning_plugin.api

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.scanning_plugin.api.scan_launchers.*
import com.estimote.scanning_plugin.api.use_cases.ScanUseCase
import com.estimote.scanning_plugin.packet_provider.PacketProvider
import io.reactivex.Observable


internal class EstimoteBluetoothScanner(private val packetProviderLoader: () -> Observable<PacketProvider>) : BluetoothScanner {

    override fun beaconScan() =
            SimpleBeaconScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideIBeacon(settings) }))

    override fun estimoteLocationScan() =
            SimpleEstimoteLocationScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteLocation(settings) }))

    override fun eddystoneUidScan() =
            SimpleEddystoneUidScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEddystoneUid(settings) }))

    override fun estimoteMeshScan() =
            SimpleEstimoteMeshScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteMesh(settings) }))

    override fun estimoteConnectivityScan() =
            SimpleEstimoteConnectivityScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideConnectivity(settings) }))

    override fun estimoteNearableScan() =
            SimpleEstimoteNearableScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideNearable(settings) }))

    override fun estimoteUwbScan() =
            SimpleEstimoteUwbScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteUwb(settings) }))

    override fun estimoteMirrorScan() =
            SimpleEstimoteMirrorScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteMirror(settings) }))

    override fun estimoteTelemetryFrameAScan() =
            SimpleEstimoteTelemetryFrameAScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteTelemetryFrameA(settings) }))

    override fun estimoteTelemetryFrameBScan() =
            SimpleEstimoteTelemetryFrameBScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteTelemetryFrameB(settings) }))

    override fun estimoteTelemetryFullScan() =
            SimpleEstimoteTelemetryFullScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteTelemetryFull(settings) }))

    override fun estimoteSecureScan() =
            SimpleEstimoteSecureScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteSecure(settings) }))

    override fun estimoteRescueScan() =
            SimpleEstimoteRescueScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteRescue(settings) }))

    override fun estimoteRemoteLocationScan() =
            SimpleEstimoteRemoteLocationScannerScanLauncher(ScanUseCase(packetProviderLoader, { packetProvider, settings -> packetProvider.provideEstimoteRemoteLocation(settings) }))


}