package com.estimote.scanning_plugin.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.EstimoteNearablePacket
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_plugin.settings.NearableScanSettings
import io.reactivex.Observable

internal class EstimoteNearableScanUseCase(private val estimoteScanner: EstimoteScanner,
                                           private val recognizer: EstimoteScanResultRecognizer,
                                           private val parser: EstimoteScanResultParser<EstimoteNearablePacket>,
                                           private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: NearableScanSettings): Observable<EstimoteNearablePacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteNearablePacket.smoothRssi(): EstimoteNearablePacket {
        val smoother = rssiSmootherCache.get( deviceId )
        val smoothedRssi = smoother.smooth(rssi, this.timestamp/ 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}