package com.estimote.scanning_plugin.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.EstimoteLteBeaconPacket
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_plugin.settings.LteBeaconScanSettings
import io.reactivex.Observable

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class EstimoteLteScanUseCase(private val estimoteScanner: EstimoteScanner,
                                      private val recognizer: EstimoteScanResultRecognizer,
                                      private val parser: EstimoteScanResultParser<EstimoteLteBeaconPacket>,
                                      private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: LteBeaconScanSettings): Observable<EstimoteLteBeaconPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EstimoteLteBeaconPacket.smoothRssi(): EstimoteLteBeaconPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi, this.timestamp / 1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }
}