package com.estimote.scanning_plugin.packet_provider.use_cases

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.EddystoneUidPacket
import com.estimote.scanning_plugin.packet_provider.rssi_smoothers.RssiSmoother
import com.estimote.scanning_plugin.settings.EddystoneScanSettings
import io.reactivex.Observable

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class EddystoneUidScanUseCase(private val estimoteScanner: EstimoteScanner,
                                       private val recognizer: EstimoteScanResultRecognizer,
                                       private val parser: EstimoteScanResultParser<EddystoneUidPacket>,
                                       private val rssiSmootherCache: ExpirationCache<String, RssiSmoother>) {


    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    fun run(scanSettings: EddystoneScanSettings): Observable<EddystoneUidPacket> {
        return estimoteScanner.scan(scanSettings)
                .filter { recognizer.recognize(it) }
                .map { parser.parse(it) }
                .map { it.smoothRssi() }
    }

    private fun EddystoneUidPacket.smoothRssi(): EddystoneUidPacket {
        val smoother = rssiSmootherCache.get(macAddress.address)
        val smoothedRssi = smoother.smooth(rssi,  this.timestamp /1000000000.0)
        return this.copy(rssi = smoothedRssi.toInt())
    }

}

