package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer.ScanFilterTransformer
import com.estimote.scanning_plugin.settings.NearableScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToNearableFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig): ScanFilterTransformer<NearableScanSettings> {
    private val ESTIMOTE_MANUFACTURER_ID = 0x015D
    private val NEARABLE_PROTOCOL_VERSION = byteArrayOf(0x01)
    private val NEARABLE_PROTOCOL_MASK = byteArrayOf(0xFF.toByte())


    override fun transform(settings: NearableScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder()
                .setManufacturerData(ESTIMOTE_MANUFACTURER_ID, NEARABLE_PROTOCOL_VERSION, NEARABLE_PROTOCOL_MASK )
                .build())
    }
}