package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer.ScanFilterTransformer
import com.estimote.scanning_plugin.settings.IBeaconScanSettings

import java.nio.ByteBuffer

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToIBeaconFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory) : ScanFilterTransformer<IBeaconScanSettings> {
    private val APPLE_MANUFACTURER_ID = 0x004c
    private val APPLE_PREAMBLE = byteArrayOf(0x02, 0x015)

    override fun transform(settings: IBeaconScanSettings) = listOf(filterBuilderFactory.newBuilder().setManufacturerData(APPLE_MANUFACTURER_ID,
                    APPLE_PREAMBLE + uuidBytes(settings) + majorBytes(settings) + minorBytes(settings))
                    .build())

    private fun uuidBytes(settings: IBeaconScanSettings) =
            (settings.uuid?.mostSignificantBits?.toBytes() ?: byteArrayOf()) + (settings.uuid?.leastSignificantBits?.toBytes() ?: byteArrayOf())

    private fun majorBytes(settings: IBeaconScanSettings) =
            if (settings.uuid != null) settings.major?.toBytes() ?: byteArrayOf()
            else byteArrayOf()

    private fun minorBytes(settings: IBeaconScanSettings) =
            if (settings.uuid != null && settings.major != null) settings.minor?.toBytes() ?: byteArrayOf()
            else byteArrayOf()

    private fun Long.toBytes() = ByteBuffer.allocate(8).putLong(this).array()

    private fun Short.toBytes() = ByteBuffer.allocate(2).putShort(this).array()
}