package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.EstimoteRescueScanSettings

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class ToEstimoteRescueFilterTransformer(private val filterBuilderFactory: HardwareFilterBuilderFactory, private val servicesUuidConfig: ServicesUuidConfig):  DefaultScanFiltersTransformer.ScanFilterTransformer<EstimoteRescueScanSettings> {

    override fun transform(settings: EstimoteRescueScanSettings): List<ScanFilter> {
        return listOf(filterBuilderFactory.newBuilder().setServiceUuid(servicesUuidConfig.estimoteUUID).build())
    }
}