package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers

import android.annotation.TargetApi
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.settings.*

/**
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.N)
internal class DefaultScanFiltersTransformer(
        private val toIBeaconFilterTransformer: ScanFilterTransformer<IBeaconScanSettings>,
        private val toEddystoneUuidFilterTransformer: ScanFilterTransformer<EddystoneScanSettings>,
        private val toTelemetryFilterTransformer: ScanFilterTransformer<EstimoteTelemetryScanSettings>,
        private val toEstimoteLocationFilterTransformer: ScanFilterTransformer<EstimoteLocationScanSettings>,
        private val toEstimoteMeshFilterTransformer: ScanFilterTransformer<EstimoteMeshScanSettings>,
        private val toMirrorFilterTransformer: ScanFilterTransformer<MirrorScanSettings>,
        private val toUwbFilterTransformer: ScanFilterTransformer<UwbScanSettings>,
        private val toNearableFilterTransformer: ScanFilterTransformer<NearableScanSettings>,
        private val toConnectivityFilterTransformer: ScanFilterTransformer<ConnectivityScanSettings>,
        private val toEstimoteSecureFilterTransformers: ScanFilterTransformer<EstimoteSecureScanSettings>,
        private val toEstimoteRescueFilterTransformer: ScanFilterTransformer<EstimoteRescueScanSettings>,
        private val toLteBeaconFilterTransformer: ScanFilterTransformer<LteBeaconScanSettings>,
        private val toRemoteLocationFilterTransformer: ScanFilterTransformer<RemoteLocationScanSettings>) : ScanSettingsVisitor<List<ScanFilter>> {


    interface ScanFilterTransformer<in SETTINGS_TYPE> {
        fun transform(settings: SETTINGS_TYPE): List<ScanFilter>
    }

    override fun visit(estimoteScanResult: IBeaconScanSettings) =
            toIBeaconFilterTransformer.transform(estimoteScanResult)

    override fun visit(estimoteScanResult: EddystoneScanSettings) =
            toEddystoneUuidFilterTransformer.transform(estimoteScanResult)

    override fun visit(telemetryScanSettings: EstimoteTelemetryScanSettings) =
            toTelemetryFilterTransformer.transform(telemetryScanSettings)

    override fun visit(estimoteLocationScanSettings: EstimoteLocationScanSettings) =
            toEstimoteLocationFilterTransformer.transform(estimoteLocationScanSettings)

    override fun visit(estimoteMeshScanSettings: EstimoteMeshScanSettings) =
            toEstimoteMeshFilterTransformer.transform(estimoteMeshScanSettings)

    override fun visit(mirrorScanSettings: MirrorScanSettings) =
            toMirrorFilterTransformer.transform(mirrorScanSettings)

    override fun visit(uwbScanSettings: UwbScanSettings) =
            toUwbFilterTransformer.transform(uwbScanSettings)

    override fun visit(nearableScanSettings: NearableScanSettings) =
            toNearableFilterTransformer.transform(nearableScanSettings)

    override fun visit(connectivityScanSettings: ConnectivityScanSettings) =
            toConnectivityFilterTransformer.transform(connectivityScanSettings)

    override fun visit(secureScanSettings: EstimoteSecureScanSettings) =
            toEstimoteSecureFilterTransformers.transform(secureScanSettings)

    override fun visit(rescueScanSettings: EstimoteRescueScanSettings) =
            toEstimoteRescueFilterTransformer.transform(rescueScanSettings)

    override fun visit(lteBeaconScanSettings: LteBeaconScanSettings) =
        toLteBeaconFilterTransformer.transform(lteBeaconScanSettings)

    override fun visit(remoteLocationScanSettings: RemoteLocationScanSettings) =
        toRemoteLocationFilterTransformer.transform(remoteLocationScanSettings)
}