package com.estimote.scanning_plugin.packet_provider.rssi_smoothers


/**
 * Stateful filter for RSSI of one signal source
 * @author Pawel Dylag (pawel.dylag@estimote.com)
 */
internal class FastPredictiveVarianceRssiSmoother : RssiSmoother {

    private val INITIAL_RSSI = -90.0
    private val INITIAL_VARIANCE = 1000000000000.0
    private val RSSI_MEASUREMENT_NOISE_VARIANCE = 25.0
    private val RSSI_MODEL_NOISE = 0.1
    private val RSSI_VELOCITY_MODEL_NOISE = 0.01

    private var x = 0.0
    private var v = 0.0
    private var pXX = 0.0
    private var pXV = 0.0
    private var pVX = 0.0
    private var pVV = 0.0
    private var filteredRssi: Double = 0.0
    private var lastUpdateTimeSeconds: Double = 0.0

    init {
        this.x = INITIAL_RSSI
        this.v = 0.0
        this.filteredRssi = this.x
        this.pXX = INITIAL_VARIANCE
        this.pVV = INITIAL_VARIANCE
        this.pVX = 0.0
        this.pXV = 0.0
    }

    override fun smooth(rssi: Int, timestampSeconds: Double): Double {
        val newRssi = rssi.toDouble()
        var dT = 0.0
        if (this.lastUpdateTimeSeconds > 0.0) {
            dT = (timestampSeconds - lastUpdateTimeSeconds)
        }
        this.lastUpdateTimeSeconds = timestampSeconds
        val x = this.x
        val v = this.v
        val pXX = this.pXX
        val pXV = this.pXV
        val pVX = this.pVX
        val pVV = this.pVV
        this.v = v - (dT * pVV + pVX) * (-newRssi + dT * v + x) / ((dT * (dT * pVV + pVX + pXV) + pXX + RSSI_MEASUREMENT_NOISE_VARIANCE) + dT * RSSI_MODEL_NOISE)
        this.x = newRssi + (RSSI_MEASUREMENT_NOISE_VARIANCE  * (-newRssi + dT * v + x)) / ((dT * (dT * pVV + pVX + pXV) + pXX + RSSI_MEASUREMENT_NOISE_VARIANCE) + dT * RSSI_MODEL_NOISE)
        this.pVV = pVV + dT * RSSI_VELOCITY_MODEL_NOISE - ((dT * pVV + pVX) * (dT * pVV + pXV)) / ((dT * (dT * pVV + pVX + pXV) + pXX + RSSI_MEASUREMENT_NOISE_VARIANCE) + dT * RSSI_MODEL_NOISE)
        this.pVX = ((dT * pVV + pVX) * RSSI_MEASUREMENT_NOISE_VARIANCE) / ((dT * (dT * pVV + pVX + pXV) + pXX + RSSI_MEASUREMENT_NOISE_VARIANCE) + dT * RSSI_MODEL_NOISE)
        this.pXV = this.pVX
        this.pXX = RSSI_MEASUREMENT_NOISE_VARIANCE - (RSSI_MEASUREMENT_NOISE_VARIANCE * RSSI_MEASUREMENT_NOISE_VARIANCE) / ((dT * (dT * pVV + pVX + pXV) + pXX + RSSI_MEASUREMENT_NOISE_VARIANCE) + dT * RSSI_MODEL_NOISE)
        this.filteredRssi = this.x
        return filteredRssi
    }


}