package com.estimote.scanning_plugin.packet_provider.recognizers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer
import java.util.*

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteSecureRecognizer : EstimoteScanResultRecognizer {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))
    private val ESTIMOTE_SECURE_PREFIX = 0x0E

    override fun recognize(result: EstimoteScanResult) =
            result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID) != null
                    && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID).isNotEmpty()
                    && result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID)[0].toInt() and 0x0F == ESTIMOTE_SECURE_PREFIX

}