package com.estimote.scanning_plugin.packet_provider.parsers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_plugin.common.toHex
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress
import com.estimote.scanning_plugin.packet_provider.EstimoteRescuePacket
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser
import java.nio.ByteBuffer
import java.util.*

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteRescueParser: EstimoteScanResultParser<EstimoteRescuePacket> {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))

    override fun parse(result: EstimoteScanResult): EstimoteRescuePacket {
        val serviceData = ByteBuffer.wrap(result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID))

        with(serviceData) {
            return EstimoteRescuePacket(
                    getOwnId(),
                    getNeighbourDeviceId(),
                    getNeighbourUpToDateStatus(),
                    EstimoteMacAddress(result.device.address),
                    result.rssi,
                    result.timestampNanosSinceBoot
            )
        }
    }

    private fun ByteBuffer.getOwnId(): String {
        val bytes = ByteArray(4)
        position(1)
        get(bytes, 0, 4)
        return bytes.toHex()
    }

    private fun ByteBuffer.getNeighbourDeviceId(): String {
        val bytes = ByteArray(4)
        position(5)
        get(bytes, 0, 4)
        return bytes.toHex()
    }

    private fun ByteBuffer.getNeighbourUpToDateStatus(): Boolean {
        return get(9) > 0
    }
}