package com.estimote.scanning_plugin.packet_provider.parsers

import android.annotation.TargetApi
import android.os.Build
import android.os.ParcelUuid
import com.estimote.scanning_plugin.common.toHex
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress
import com.estimote.scanning_plugin.packet_provider.EstimoteMirrorPacket
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser
import java.nio.ByteBuffer
import java.util.*

/**
 * @author Lukasz Pobereznik (lukasz.pobereznik@estimote.com)
 */
@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal class EstimoteMirrorParser : EstimoteScanResultParser<EstimoteMirrorPacket> {

    private val ESTIMOTE_SERVICE_UUID = ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"))

    override fun parse(result: EstimoteScanResult): EstimoteMirrorPacket {
        val bytes = ByteBuffer.wrap(result.scanRecord.getServiceData(ESTIMOTE_SERVICE_UUID))
        with(bytes) {
            return EstimoteMirrorPacket(
                    getDeviceId(),
                    EstimoteMacAddress(result.device.address),
                    getProtocolVersion(),
                    getMeasuredPower(),
                    result.rssi,
                    getAccessControl(),
                    result.timestampNanosSinceBoot
            )
        }
    }

    private fun ByteBuffer.getAccessControl() : Boolean = this.get(18).toInt() and 0x80 > 0

    private fun ByteBuffer.getDeviceId(): String {
        val idBytes = ByteArray(16)
        position(1)
        get(idBytes, 0, 16)
        return idBytes.toHex()
    }

    private fun ByteBuffer.getMeasuredPower(): Int = this.get(17).toInt()

    private fun ByteBuffer.getProtocolVersion(): Int = this.get(0).toInt() and 0xF0 shr 4


}