package com.estimote.scanning_plugin.packet_provider.antenna_bias

/**
 * @author Estimote Inc. (contact@estimote.com)
 */
internal class AntennaBiasCorrectionFactory {

    fun getAntennaBiasForDevice(manufacturer: String, deviceModel: String): AntennaBiasCorrection =
            AntennaBiasCorrection(getAntennaBiasForManufacturer(manufacturer, deviceModel))

    private fun getAntennaBiasForManufacturer(manufacturer: String, deviceModel: String): Int = when(manufacturer.toLowerCase()) {
        "huawei" -> biasForHuaweiDevices(deviceModel)
        "motorola" -> biasForMotorolaDevices(deviceModel)
        "oneplus" -> biasForOnePlusDevices(deviceModel)
        "google" -> biasForGoogleDevices(deviceModel)
        "samsung" -> biasForSamsungDevices(deviceModel)
        "sony" -> biasForSonyDevices(deviceModel)
        else -> 0
    }

    private fun biasForMotorolaDevices(deviceModel: String): Int = when(deviceModel) {
        "Nexus 6" -> -6
        else -> 0
    }

    private fun biasForSonyDevices(deviceModel: String): Int = when(deviceModel) {
        "F8331" -> 6
        else -> 0
    }

    private fun biasForOnePlusDevices(deviceModel: String): Int = when(deviceModel) {
        "A0001" -> 2
        "One" -> 2
        else -> 0
    }

    private fun biasForHuaweiDevices(deviceModel: String): Int = when(deviceModel) {
        "Nexus 6P" -> 0
        else -> 0
    }

    private fun biasForSamsungDevices(deviceModel: String): Int = when(deviceModel) {
        "SM-G920F" -> -2
        "SM-G950F" -> -2
        else -> 0
    }

    private fun biasForGoogleDevices(deviceModel: String): Int = when(deviceModel) {
        "Pixel" -> 5
        "Pixel XL" -> 2
        else -> 0
    }
}