package com.estimote.scanning_plugin.dagger

import android.annotation.TargetApi
import android.bluetooth.BluetoothAdapter
import android.bluetooth.le.ScanFilter
import android.os.Build
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.*
import com.estimote.scanning_plugin.packet_provider.scanner.settings_transformers.ScanSettingsTransformerProvider
import com.estimote.scanning_plugin.settings.ScanSettingsVisitor
import dagger.Module
import dagger.Provides

@Module
internal class ScanSettingsTransformersModule(private val androidApiVersion: Int,
                                              private val manufacturerId: String) {

    @Provides
    @EstimoteScanningSdkScope
    fun provideServicesUuidConfig() = ServicesUuidConfig()

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    @Provides
    @EstimoteScanningSdkScope
    fun provideEstimoteSettingsToFilterTransformer(bluetoothAdapter: BluetoothAdapter?,
                                                   servicesUuidConfig: ServicesUuidConfig): ScanSettingsVisitor<@JvmWildcard List<ScanFilter>> =
            if (bluetoothAdapter != null && bluetoothAdapter.isOffloadedFilteringSupported) {
                DefaultScanFiltersTransformer(
                        ToIBeaconFilterTransformer(HardwareFilterBuilderFactory()),
                        ToEddystoneFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToEstimoteTelemetryFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToEstimoteLocationFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToEstimoteMeshFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToMirrorFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToUwbFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToNearableFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToConfigurableDeviceFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToEstimoteSecureFilterTransformers(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToEstimoteRescueFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToLteBeaconFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig),
                        ToRemoteLocationFilterTransformer(HardwareFilterBuilderFactory(), servicesUuidConfig))
            } else {
                NoScanFiltersTransformer()
            }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    @Provides
    @EstimoteScanningSdkScope
    fun provideScanSettingsTransformerProvider(bluetoothAdapter: BluetoothAdapter?): ScanSettingsTransformerProvider =
            ScanSettingsTransformerProvider(androidApiVersion, manufacturerId, bluetoothAdapter?.isOffloadedScanBatchingSupported ?: false)
}