package com.estimote.scanning_plugin.dagger

import com.estimote.scanning_plugin.api.EstimoteBluetoothScannerFactory
import dagger.Component

@EstimoteScanningSdkScope
@Component(modules = [
    (EstimoteScanningSdkModule::class),
    (BluetoothModule::class),
    (ScannerModule::class),
    (UseCaseModule::class),
    (PacketProviderModule::class),
    (ScanSettingsTransformersModule::class),
    (BluetoothTriggerModule::class)])
internal interface EstimoteScanningSdkComponent {
    fun inject(bluetoothScannerFactory: EstimoteBluetoothScannerFactory)
    fun plus(notificationModule: NotificationModule): NotificationComponent
}