package com.estimote.scanning_plugin.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.EstimoteLteBeacon
import com.estimote.scanning_plugin.api.use_cases.ScanUseCase
import com.estimote.scanning_plugin.settings.EstimoteScanSettings
import com.estimote.scanning_plugin.settings.LteBeaconScanSettings

/**
 * @author Estimote Inc. (contact@estimote.com)
 */


internal class SimpleEstimoteLteBeaconScannerScanLauncher(useCase: ScanUseCase<LteBeaconScanSettings, EstimoteLteBeacon>):
        BaseScannerScanLauncher<LteBeaconScanSettings, EstimoteLteBeacon, SimpleEstimoteLteBeaconScannerScanLauncher>(useCase), BluetoothScanner.EstimoteLteBeaconScannerScanLauncher {

    override val buildSettings: (SimpleEstimoteLteBeaconScannerScanLauncher) -> LteBeaconScanSettings = { LteBeaconScanSettings(it.powerMode, EstimoteScanSettings.ScanCallbackMode.ALL_MATCH) }
}