package com.estimote.scanning_plugin.api.scan_launchers

import com.estimote.internal_plugins_api.scanning.BluetoothScanner
import com.estimote.internal_plugins_api.scanning.EddystoneUid
import com.estimote.scanning_plugin.api.use_cases.ScanUseCase
import com.estimote.scanning_plugin.settings.EddystoneScanSettings
import com.estimote.scanning_plugin.settings.EstimoteScanSettings

internal class SimpleEddystoneUidScannerScanLauncher(useCase: ScanUseCase<EddystoneScanSettings, EddystoneUid>):
        BaseScannerScanLauncher<EddystoneScanSettings, EddystoneUid, SimpleEddystoneUidScannerScanLauncher>(useCase), BluetoothScanner.EddystoneUidScannerScanLauncher {
    override val buildSettings: (SimpleEddystoneUidScannerScanLauncher) -> EddystoneScanSettings = { EddystoneScanSettings(it.powerMode, EstimoteScanSettings.ScanCallbackMode.ALL_MATCH) }
}