/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanFilter;
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.DefaultScanFiltersTransformer;
import com.estimote.scanning_plugin.packet_provider.scanner.filter_transformers.HardwareFilterBuilderFactory;
import com.estimote.scanning_plugin.settings.IBeaconScanSettings;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\n\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u001e\u0010\r\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J\u0014\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\t0\t*\u00020\u0013H\u0002J\u0014\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\t0\t*\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/scanner/filter_transformers/ToIBeaconFilterTransformer;", "Lcom/estimote/scanning_plugin/packet_provider/scanner/filter_transformers/DefaultScanFiltersTransformer$ScanFilterTransformer;", "Lcom/estimote/scanning_plugin/settings/IBeaconScanSettings;", "filterBuilderFactory", "Lcom/estimote/scanning_plugin/packet_provider/scanner/filter_transformers/HardwareFilterBuilderFactory;", "(Lcom/estimote/scanning_plugin/packet_provider/scanner/filter_transformers/HardwareFilterBuilderFactory;)V", "APPLE_MANUFACTURER_ID", "", "APPLE_PREAMBLE", "", "majorBytes", "settings", "minorBytes", "transform", "", "Landroid/bluetooth/le/ScanFilter;", "kotlin.jvm.PlatformType", "uuidBytes", "toBytes", "", "", "scanning-plugin_release"})
@TargetApi(value=21)
public final class ToIBeaconFilterTransformer
implements DefaultScanFiltersTransformer.ScanFilterTransformer<IBeaconScanSettings> {
    private final int APPLE_MANUFACTURER_ID = 76;
    private final byte[] APPLE_PREAMBLE;
    private final HardwareFilterBuilderFactory filterBuilderFactory;

    @Override
    @NotNull
    public List<ScanFilter> transform(@NotNull IBeaconScanSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return CollectionsKt.listOf((Object)this.filterBuilderFactory.newBuilder().setManufacturerData(this.APPLE_MANUFACTURER_ID, ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])this.APPLE_PREAMBLE, (byte[])this.uuidBytes(settings)), (byte[])this.majorBytes(settings)), (byte[])this.minorBytes(settings))).build());
    }

    private final byte[] uuidBytes(IBeaconScanSettings settings) {
        Object object;
        Object object2;
        block7: {
            block6: {
                block5: {
                    block4: {
                        object2 = settings.getUuid();
                        if (object2 == null) break block4;
                        byte[] byArray = this.toBytes(((UUID)object2).getMostSignificantBits());
                        object2 = byArray;
                        if (byArray != null) break block5;
                    }
                    object2 = new byte[0];
                }
                if ((object = settings.getUuid()) == null) break block6;
                byte[] byArray = this.toBytes(((UUID)object).getLeastSignificantBits());
                object = byArray;
                if (byArray != null) break block7;
            }
            object = new byte[0];
        }
        return ArraysKt.plus((byte[])object2, (byte[])object);
    }

    private final byte[] majorBytes(IBeaconScanSettings settings) {
        Object object;
        if (settings.getUuid() != null) {
            Short s = settings.getMajor();
            object = s;
            if (s == null || (object = this.toBytes(object.shortValue())) == null) {
                object = new byte[0];
            }
        } else {
            object = new byte[]{};
        }
        return object;
    }

    private final byte[] minorBytes(IBeaconScanSettings settings) {
        Object object;
        if (settings.getUuid() != null && settings.getMajor() != null) {
            Short s = settings.getMinor();
            object = s;
            if (s == null || (object = this.toBytes(object.shortValue())) == null) {
                object = new byte[0];
            }
        } else {
            object = new byte[]{};
        }
        return object;
    }

    private final byte[] toBytes(long $receiver) {
        return ByteBuffer.allocate(8).putLong($receiver).array();
    }

    private final byte[] toBytes(short $receiver) {
        return ByteBuffer.allocate(2).putShort($receiver).array();
    }

    public ToIBeaconFilterTransformer(@NotNull HardwareFilterBuilderFactory filterBuilderFactory) {
        Intrinsics.checkParameterIsNotNull((Object)filterBuilderFactory, (String)"filterBuilderFactory");
        this.filterBuilderFactory = filterBuilderFactory;
        this.APPLE_MANUFACTURER_ID = 76;
        this.APPLE_PREAMBLE = new byte[]{2, 21};
    }
}

