/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.recognizers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultRecognizer;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/recognizers/EstimoteLteRecognizer;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultRecognizer;", "()V", "ESTIMOTE_CONNECTIVITY_FRAME_TYPE", "", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "recognize", "", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "getApplicationVersion", "", "Ljava/nio/ByteBuffer;", "getBootloaderVersion", "toVersionOctet", "", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EstimoteLteRecognizer
implements EstimoteScanResultRecognizer {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));
    private final int ESTIMOTE_CONNECTIVITY_FRAME_TYPE = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean recognize(@NotNull EstimoteScanResult result) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        if (result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID) == null) return false;
        byte[] byArray2 = result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"result.scanRecord.getSer\u2026ta(ESTIMOTE_SERVICE_UUID)");
        byte[] byArray3 = byArray = byArray2;
        if (byArray3.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if ((result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID)[0] & 0xF) != this.ESTIMOTE_CONNECTIVITY_FRAME_TYPE) return false;
        ByteBuffer byteBuffer = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        ByteBuffer byteBuffer2 = byteBuffer;
        if (Intrinsics.areEqual((Object)this.getApplicationVersion(byteBuffer2), (Object)"15.15.15")) {
            if (Intrinsics.areEqual((Object)this.getBootloaderVersion(byteBuffer2), (Object)"15.15.15")) return true;
        }
        if (Intrinsics.areEqual((Object)this.getApplicationVersion(byteBuffer2), (Object)"0.0.0")) {
            if (Intrinsics.areEqual((Object)this.getBootloaderVersion(byteBuffer2), (Object)"0.1.11")) return true;
        }
        if (Intrinsics.areEqual((Object)this.getApplicationVersion(byteBuffer2), (Object)"0.0.12")) {
            if (Intrinsics.areEqual((Object)this.getBootloaderVersion(byteBuffer2), (Object)"0.0.1")) return true;
        }
        if (!Intrinsics.areEqual((Object)this.getApplicationVersion(byteBuffer2), (Object)"0.0.13")) return false;
        if (!Intrinsics.areEqual((Object)this.getBootloaderVersion(byteBuffer2), (Object)"0.0.1")) return false;
        return true;
    }

    private final String getBootloaderVersion(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[2];
        $receiver.position(18);
        $receiver.get(bytes, 0, 2);
        return "" + this.toVersionOctet(bytes[1] >> 4) + '.' + this.toVersionOctet(bytes[1]) + '.' + this.toVersionOctet(bytes[0] >> 4);
    }

    private final String getApplicationVersion(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[2];
        $receiver.position(17);
        $receiver.get(bytes, 0, 2);
        return "" + this.toVersionOctet(bytes[1]) + '.' + this.toVersionOctet(bytes[0] >> 4) + '.' + this.toVersionOctet(bytes[0]);
    }

    private final String toVersionOctet(byte $receiver) {
        byte by = $receiver;
        int n = 15;
        return String.valueOf((byte)(by & n));
    }

    private final String toVersionOctet(int $receiver) {
        return String.valueOf($receiver & 0xF);
    }
}

