/*
 * Decompiled with CFR 0.152.
 */
package com.estimote.scanning_plugin.packet_provider.parsers;

import android.annotation.TargetApi;
import android.os.ParcelUuid;
import com.estimote.scanning_plugin.common.ByteExtensionsKt;
import com.estimote.scanning_plugin.packet_provider.EstimoteMacAddress;
import com.estimote.scanning_plugin.packet_provider.EstimoteRescuePacket;
import com.estimote.scanning_plugin.packet_provider.scanner.EstimoteScanResult;
import com.estimote.scanning_plugin.packet_provider.use_cases.EstimoteScanResultParser;
import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\n*\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/estimote/scanning_plugin/packet_provider/parsers/EstimoteRescueParser;", "Lcom/estimote/scanning_plugin/packet_provider/use_cases/EstimoteScanResultParser;", "Lcom/estimote/scanning_plugin/packet_provider/EstimoteRescuePacket;", "()V", "ESTIMOTE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "parse", "result", "Lcom/estimote/scanning_plugin/packet_provider/scanner/EstimoteScanResult;", "getNeighbourDeviceId", "", "Ljava/nio/ByteBuffer;", "getNeighbourUpToDateStatus", "", "getOwnId", "scanning-plugin_release"})
@TargetApi(value=21)
public final class EstimoteRescueParser
implements EstimoteScanResultParser<EstimoteRescuePacket> {
    private final ParcelUuid ESTIMOTE_SERVICE_UUID = new ParcelUuid(UUID.fromString("0000fe9a-0000-1000-8000-00805f9b34fb"));

    @Override
    @NotNull
    public EstimoteRescuePacket parse(@NotNull EstimoteScanResult result) {
        ByteBuffer serviceData;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        ByteBuffer $receiver = serviceData = ByteBuffer.wrap(result.getScanRecord().getServiceData(this.ESTIMOTE_SERVICE_UUID));
        String string = this.getOwnId($receiver);
        String string2 = this.getNeighbourDeviceId($receiver);
        boolean bl = this.getNeighbourUpToDateStatus($receiver);
        String string3 = result.getDevice().getAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"result.device.address");
        return new EstimoteRescuePacket(string, string2, bl, new EstimoteMacAddress(string3), result.getRssi(), result.getTimestampNanosSinceBoot());
    }

    private final String getOwnId(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[4];
        $receiver.position(1);
        $receiver.get(bytes, 0, 4);
        return ByteExtensionsKt.toHex(bytes);
    }

    private final String getNeighbourDeviceId(@NotNull ByteBuffer $receiver) {
        byte[] bytes = new byte[4];
        $receiver.position(5);
        $receiver.get(bytes, 0, 4);
        return ByteExtensionsKt.toHex(bytes);
    }

    private final boolean getNeighbourUpToDateStatus(@NotNull ByteBuffer $receiver) {
        return $receiver.get(9) > 0;
    }
}

